//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3

import wesual.Controls 1.0
import wesual.data.Core 1.0

Flow {
    id : tagGrid

    property int   tagIconSize : 25
    property int   tagNamePixelSize : 14
    property alias tagListing : repeater.model

    signal removeTag(Tag tag)

    spacing : 5

    Repeater {
        id : repeater

        delegate : Rectangle {
            id : tagWrapper

            width : tagRow.implicitWidth + 6
            height : tagRow.implicitHeight + 6
            border {
                width : tagMouseArea.containsMouse ||
                        removeTagMouseArea.containsMouse
                        ? 1 : 0
                color : UI.color(UI.PrimaryControlBorder)
            }
            MouseArea {
                id : tagMouseArea
                anchors.fill : tagWrapper
                hoverEnabled : true
            }
            Row {
                id : tagRow
                anchors.centerIn : parent
                spacing : 5

                TagIcon {
                    id : tagImg
                    width : tagIconSize
                    height : tagIconSize
                    tag : modelData
                    tintColor : "black"
                    anchors.verticalCenter : parent.verticalCenter
                }
                Text {
                    text : modelData.name
                    anchors.verticalCenter : parent.verticalCenter
                    font {
                        family : UI.fontFamily(UI.PrimaryFont)
                        weight : UI.fontWeight(UI.SecondaryFont)
                        pixelSize : tagNamePixelSize
                    }
                }
                Item {
                    width : 11
                    height : 8
                    Image {
                        anchors.fill : parent
                        source : "qrc:/controls/icons/remove-tag.png"
                        opacity : removeTagMouseArea.containsMouse ? 1.0 : 0.6

                        sourceSize {
                            width  : 11
                            height :  8
                        }

                        Behavior on opacity {
                            NumberAnimation { duration : 0 }
                        }
                    }
                    MouseArea {
                        id : removeTagMouseArea
                        anchors.fill : parent
                        hoverEnabled : true
                        onClicked : tagGrid.removeTag(modelData);
                        cursorShape : Qt.PointingHandCursor
                    }
                    anchors.verticalCenter : parent.verticalCenter
                }
            }
        }
    }
}


